/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.bankid.rpapi.service.impl;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.util.Assert;
import se.litsec.bankid.rpapi.service.QRGenerator;

public abstract class AbstractQRGenerator
implements QRGenerator {
    public static final int DEFAULT_WIDTH = 300;
    public static final int DEFAULT_HEIGHT = 300;
    public static final QRGenerator.ImageFormat DEFAULT_IMAGE_FORMAT = QRGenerator.ImageFormat.PNG;
    private int defaultWidth = 300;
    private int defaultHeight = 300;
    private QRGenerator.ImageFormat defaultImageFormat = DEFAULT_IMAGE_FORMAT;

    protected String buildInput(String autoStartToken) {
        return "bankid:///?autostarttoken=" + autoStartToken;
    }

    protected String buildAnimatedInput(String qrStartToken, String qrStartSecret, Instant orderTime) throws IOException {
        try {
            String qrTime = Long.toString(orderTime.until(Instant.now(), ChronoUnit.SECONDS));
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(qrStartSecret.getBytes(StandardCharsets.US_ASCII), "HmacSHA256"));
            mac.update(qrTime.getBytes(StandardCharsets.US_ASCII));
            String qrAuthCode = String.format("%064x", new BigInteger(1, mac.doFinal()));
            return String.join((CharSequence)".", "bankid", qrStartToken, qrTime, qrAuthCode);
        }
        catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IOException("Failed to compute HMAC", e);
        }
    }

    @Override
    public byte[] generateQRCodeImage(String autoStartToken) throws IOException {
        return this.generateQRCodeImage(autoStartToken, this.defaultWidth, this.defaultHeight, this.defaultImageFormat);
    }

    @Override
    public byte[] generateAnimatedQRCodeImage(String qrStartToken, String qrStartSecret, Instant orderTime) throws IOException {
        return this.generateAnimatedQRCodeImage(qrStartToken, qrStartSecret, orderTime, this.defaultWidth, this.defaultHeight, this.defaultImageFormat);
    }

    @Override
    public String generateQRCodeBase64Image(String autoStartToken, int width, int height, QRGenerator.ImageFormat format) throws IOException {
        byte[] imageBytes = this.generateQRCodeImage(autoStartToken, width, height, format);
        return String.format("data:image/%s;base64, %s", format.getImageFormatName().toLowerCase(), Base64.getEncoder().encodeToString(imageBytes));
    }

    @Override
    public String generateQRCodeBase64Image(String autoStartToken) throws IOException {
        return this.generateQRCodeBase64Image(autoStartToken, this.defaultWidth, this.defaultHeight, this.defaultImageFormat);
    }

    @Override
    public String generateAnimatedQRCodeBase64Image(String qrStartToken, String qrStartSecret, Instant orderTime, int width, int height, QRGenerator.ImageFormat format) throws IOException {
        byte[] imageBytes = this.generateAnimatedQRCodeImage(qrStartToken, qrStartSecret, orderTime, width, height, format);
        return String.format("data:image/%s;base64, %s", format.getImageFormatName().toLowerCase(), Base64.getEncoder().encodeToString(imageBytes));
    }

    @Override
    public String generateAnimatedQRCodeBase64Image(String qrStartToken, String qrStartSecret, Instant orderTime) throws IOException {
        return this.generateAnimatedQRCodeBase64Image(qrStartToken, qrStartSecret, orderTime, this.defaultWidth, this.defaultHeight, this.defaultImageFormat);
    }

    public void setDefaultWidth(int defaultWidth) {
        this.defaultWidth = defaultWidth;
    }

    public void setDefaultHeight(int defaultHeight) {
        this.defaultHeight = defaultHeight;
    }

    public void setDefaultImageFormat(QRGenerator.ImageFormat defaultImageFormat) {
        Assert.notNull((Object)((Object)defaultImageFormat), (String)"defaultImageFormat must not be null");
        this.defaultImageFormat = defaultImageFormat;
    }
}

