/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.bankid.rpapi.service.impl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;
import se.litsec.bankid.rpapi.service.BankIDClient;
import se.litsec.bankid.rpapi.service.DataToSign;
import se.litsec.bankid.rpapi.service.QRGenerator;
import se.litsec.bankid.rpapi.types.BankIDException;
import se.litsec.bankid.rpapi.types.CollectResponse;
import se.litsec.bankid.rpapi.types.CollectResponseJson;
import se.litsec.bankid.rpapi.types.ErrorCode;
import se.litsec.bankid.rpapi.types.ErrorResponse;
import se.litsec.bankid.rpapi.types.OrderResponse;
import se.litsec.bankid.rpapi.types.Requirement;
import se.litsec.bankid.rpapi.types.UserCancelException;

public class BankIDClientImpl
implements BankIDClient {
    private final Logger log = LoggerFactory.getLogger(BankIDClientImpl.class);
    private RestTemplate restTemplate;
    private QRGenerator qrGenerator;
    private static ObjectMapper objectMapper = new ObjectMapper();
    private URI authUri;
    private URI signUri;
    private URI cancelUri;
    private URI collectUri;

    public BankIDClientImpl(RestTemplate restTemplate, String serviceUrl, QRGenerator qrGenerator) {
        Assert.notNull((Object)restTemplate, (String)"'restTemplate' must be not be null");
        this.restTemplate = restTemplate;
        Assert.hasText((String)serviceUrl, (String)"'serviceUrl' must not be null or empty");
        this.qrGenerator = qrGenerator;
        DefaultUriBuilderFactory uriFactory = new DefaultUriBuilderFactory(serviceUrl);
        this.authUri = uriFactory.builder().path("/auth").build(new Object[0]);
        this.signUri = uriFactory.builder().path("/sign").build(new Object[0]);
        this.cancelUri = uriFactory.builder().path("/cancel").build(new Object[0]);
        this.collectUri = uriFactory.builder().path("/collect").build(new Object[0]);
    }

    @Override
    public OrderResponse authenticate(String personalIdentityNumber, String endUserIp, Requirement requirement) throws BankIDException {
        Assert.hasText((String)endUserIp, (String)"'endUserIp' must not be null or empty");
        AuthnRequest request = new AuthnRequest(personalIdentityNumber, endUserIp, requirement);
        this.log.debug("authenticate. request: [{}] [uri: {}]", (Object)request, (Object)this.authUri);
        try {
            OrderResponse response = (OrderResponse)this.restTemplate.postForObject(this.authUri, (Object)request, OrderResponse.class);
            this.log.info("authenticate. response: [{}]", (Object)response);
            return response;
        }
        catch (HttpStatusCodeException e) {
            this.log.info("authenticate. Error during auth-call - {} - {} - {}", new Object[]{e.getMessage(), e.getStatusCode(), e.getResponseBodyAsString()});
            throw new BankIDException(this.getErrorResponse(e), "Auth-call failed", (Throwable)e);
        }
        catch (Exception e) {
            this.log.error("authenticate. Error during auth-call - {}", (Object)e.getMessage(), (Object)e);
            throw new BankIDException(ErrorCode.UNKNOWN_ERROR, "Unknown error during auth", (Throwable)e);
        }
    }

    @Override
    public OrderResponse sign(String personalIdentityNumber, String endUserIp, DataToSign dataToSign, Requirement requirement) throws BankIDException {
        Assert.hasText((String)endUserIp, (String)"'endUserIp' must not be null or empty");
        Assert.notNull((Object)dataToSign, (String)"'dataToSign' must not be null");
        Assert.hasText((String)dataToSign.getUserVisibleData(), (String)"'dataToSign.userVisibleData' must not be null");
        SignRequest request = new SignRequest(personalIdentityNumber, endUserIp, requirement, dataToSign);
        this.log.debug("sign. request: [{}] [uri: {}]", (Object)request, (Object)this.authUri);
        try {
            OrderResponse response = (OrderResponse)this.restTemplate.postForObject(this.signUri, (Object)request, OrderResponse.class);
            this.log.info("sign. response: [{}]", (Object)response);
            return response;
        }
        catch (HttpStatusCodeException e) {
            this.log.info("sign. Error during sign-call - {} - {} - {}", new Object[]{e.getMessage(), e.getStatusCode(), e.getResponseBodyAsString()});
            throw new BankIDException(this.getErrorResponse(e), "Sign-call failed", (Throwable)e);
        }
        catch (Exception e) {
            this.log.error("sign. Error during sign-call - {}", (Object)e.getMessage(), (Object)e);
            throw new BankIDException(ErrorCode.UNKNOWN_ERROR, "Unknown error during sign", (Throwable)e);
        }
    }

    @Override
    public void cancel(String orderReference) throws BankIDException {
        Assert.hasText((String)orderReference, (String)"'orderReference' must not be null or empty");
        this.log.debug("cancel: Request for cancelling order {}", (Object)orderReference);
        OrderRefRequest request = new OrderRefRequest(orderReference);
        try {
            this.restTemplate.postForObject(this.cancelUri, (Object)request, Void.class);
            this.log.info("cancel. Order {} successfully cancelled", (Object)orderReference);
        }
        catch (HttpStatusCodeException e) {
            this.log.info("cancel. Error during cancel-call - {} - {} - {}", new Object[]{e.getMessage(), e.getStatusCode(), e.getResponseBodyAsString()});
            throw new BankIDException(this.getErrorResponse(e), "Cancel-call failed", (Throwable)e);
        }
        catch (Exception e) {
            this.log.error("cancel. Error during cancel-call - {}", (Object)e.getMessage(), (Object)e);
            throw new BankIDException(ErrorCode.UNKNOWN_ERROR, "Unknown error during cancel", (Throwable)e);
        }
    }

    @Override
    public CollectResponse collect(String orderReference) throws UserCancelException, BankIDException {
        Assert.hasText((String)orderReference, (String)"'orderReference' must not be null or empty");
        this.log.debug("collect: Request for collecting order {}", (Object)orderReference);
        OrderRefRequest request = new OrderRefRequest(orderReference);
        try {
            CollectResponseJson response = (CollectResponseJson)this.restTemplate.postForObject(this.collectUri, (Object)request, CollectResponseJson.class);
            this.log.info("collect. response: [{}]", (Object)response);
            if (CollectResponseJson.Status.FAILED.equals((Object)response.getStatus())) {
                throw new BankIDException(response.getErrorCode(), String.format("Order '%s' failed with code '%s'", orderReference, response.getErrorCode().getValue()));
            }
            return response;
        }
        catch (HttpStatusCodeException e) {
            this.log.info("cancel. Error during cancel-call - {} - {} - {}", new Object[]{e.getMessage(), e.getStatusCode(), e.getResponseBodyAsString()});
            throw new BankIDException(this.getErrorResponse(e), "Cancel-call failed", (Throwable)e);
        }
        catch (Exception e) {
            this.log.error("cancel. Error during cancel-call - {}", (Object)e.getMessage(), (Object)e);
            throw new BankIDException(ErrorCode.UNKNOWN_ERROR, "Unknown error during cancel", (Throwable)e);
        }
    }

    @Override
    public QRGenerator getQRGenerator() {
        return this.qrGenerator;
    }

    private ErrorResponse getErrorResponse(HttpStatusCodeException exception) {
        byte[] body = exception.getResponseBodyAsByteArray();
        if (body == null) {
            return new ErrorResponse(ErrorCode.UNKNOWN_ERROR, null);
        }
        try {
            return (ErrorResponse)objectMapper.readValue(body, ErrorResponse.class);
        }
        catch (IOException e) {
            this.log.error("Failed to deserialize error response {} into ErrorResponse structure", (Object)exception.getResponseBodyAsString(), (Object)e);
            return new ErrorResponse(ErrorCode.UNKNOWN_ERROR, null);
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    private static class OrderRefRequest {
        private final String orderRef;

        public OrderRefRequest(String orderRef) {
            this.orderRef = orderRef;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private static class SignRequest
    extends AuthnRequest {
        private final String userVisibleData;
        private final String userNonVisibleData;

        public SignRequest(String personalNumber, String endUserIp, Requirement requirement, DataToSign dataToSign) {
            super(personalNumber, endUserIp, requirement);
            this.userVisibleData = dataToSign.getUserVisibleData();
            this.userNonVisibleData = dataToSign.getUserNonVisibleData();
        }

        @Override
        public String toString() {
            return String.format("%s, userVisibleData='%s', userNonVisibleData='%s'", super.toString(), this.userVisibleData, this.userNonVisibleData != null ? this.userNonVisibleData : "<not set>");
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private static class AuthnRequest {
        private final String personalNumber;
        private final String endUserIp;
        private final Requirement requirement;

        public AuthnRequest(String personalNumber, String endUserIp, Requirement requirement) {
            this.personalNumber = personalNumber;
            this.endUserIp = endUserIp;
            this.requirement = requirement;
        }

        public String toString() {
            return String.format("personalNumber='%s', endUserIp='%s', requirement=[%s]", this.personalNumber, this.endUserIp, this.requirement);
        }
    }
}

