/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.bankid.rpapi.service.impl;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import se.litsec.bankid.rpapi.service.QRGenerator;
import se.litsec.bankid.rpapi.service.impl.AbstractQRGenerator;

public class ZxingQRGenerator
extends AbstractQRGenerator {
    private final Logger log = LoggerFactory.getLogger(ZxingQRGenerator.class);

    @Override
    public byte[] generateQRCodeImage(String autoStartToken, int width, int height, QRGenerator.ImageFormat format) throws IOException {
        return this.generateQRCode(this.buildInput(autoStartToken), width, height, format);
    }

    @Override
    public byte[] generateAnimatedQRCodeImage(String qrStartToken, String qrStartSecret, Instant orderTime, int width, int height, QRGenerator.ImageFormat format) throws IOException {
        return this.generateQRCode(this.buildAnimatedInput(qrStartToken, qrStartSecret, orderTime), width, height, format);
    }

    private byte[] generateQRCode(String input, int width, int height, QRGenerator.ImageFormat format) throws IOException {
        if (QRGenerator.ImageFormat.SVG.equals((Object)format)) {
            throw new IOException("Image format SVG is not supported by " + this.getClass().getSimpleName());
        }
        try {
            this.log.debug("Generating QR code in {} format based on {}", (Object)format, (Object)input);
            QRCodeWriter writer = new QRCodeWriter();
            BitMatrix bytes = writer.encode(input, BarcodeFormat.QR_CODE, width, height);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            MatrixToImageWriter.writeToStream((BitMatrix)bytes, (String)format.getImageFormatName(), (OutputStream)stream);
            return stream.toByteArray();
        }
        catch (WriterException e) {
            throw new IOException("Failed to generate QR code: " + e.getMessage(), e);
        }
    }

    @Override
    public void setDefaultImageFormat(QRGenerator.ImageFormat defaultImageFormat) {
        Assert.isTrue((boolean)QRGenerator.ImageFormat.SVG.equals((Object)defaultImageFormat), (String)("Image format SVG is not supported by " + this.getClass().getSimpleName()));
        super.setDefaultImageFormat(defaultImageFormat);
    }
}

