/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.bankid.rpapi.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.util.Assert;
import se.litsec.bankid.rpapi.support.BankIDMessage;

public class BankIDMessageImpl
implements BankIDMessage {
    private BankIDMessage.ShortName shortName;
    private List<String> messageCodes;

    public BankIDMessageImpl(BankIDMessage.ShortName shortName, String ... messageCodes) {
        Assert.notNull((Object)((Object)shortName), (String)"shortName must not be null");
        Assert.notEmpty((Object[])messageCodes, (String)"messageCodes must not be empty");
        this.shortName = shortName;
        this.messageCodes = Arrays.asList(messageCodes);
    }

    public BankIDMessageImpl(BankIDMessage.ShortName shortName, List<String> messageCodes) {
        Assert.notNull((Object)((Object)shortName), (String)"shortName must not be null");
        Assert.notEmpty(messageCodes, (String)"messageCodes must not be empty");
        this.shortName = shortName;
        this.messageCodes = messageCodes;
    }

    @Override
    public BankIDMessage.ShortName getShortName() {
        return this.shortName;
    }

    @Override
    public List<String> getMessageCodes() {
        return Collections.unmodifiableList(this.messageCodes);
    }
}

