/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.bankid.rpapi.support;

import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.io.Resource;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class BankIDRestTemplateFactory
extends AbstractFactoryBean<RestTemplate> {
    private Resource trustedRoot;
    private KeyStore keyStore;
    private String keyAlias;
    private char[] keyPassword;
    private KeyStore trustStore;

    public Class<?> getObjectType() {
        return RestTemplate.class;
    }

    protected RestTemplate createInstance() throws Exception {
        PrivateKeyStrategy keyStrategy = (aliases, socket) -> this.keyAlias != null ? this.keyAlias : (String)aliases.keySet().stream().findFirst().orElse(null);
        SSLContext sslContext = SSLContextBuilder.create().loadKeyMaterial(this.keyStore, this.keyPassword, keyStrategy).loadTrustMaterial(this.trustStore, null).build();
        CloseableHttpClient httpClient = HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)new DefaultHostnameVerifier()).build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setHttpClient((HttpClient)httpClient);
        return new RestTemplate((ClientHttpRequestFactory)requestFactory);
    }

    public void setTrustedRoot(Resource trustedRoot) {
        this.trustedRoot = trustedRoot;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = StringUtils.hasText((String)keyAlias) ? keyAlias.trim() : null;
    }

    public void setKeyPassword(char[] keyPassword) {
        Assert.notNull((Object)keyPassword, (String)"'keyPassword' must not be null");
        this.keyPassword = new char[keyPassword.length];
        System.arraycopy(keyPassword, 0, this.keyPassword, 0, keyPassword.length);
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.trustedRoot, (String)"Property 'trustedRoot' must be assigned");
        Assert.notNull((Object)this.keyStore, (String)"Property 'keyStore' must be assigned");
        Assert.notNull((Object)this.keyPassword, (String)"Property 'keyPassword' must be assigned");
        this.trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        this.trustStore.load(null);
        this.trustStore.setCertificateEntry("bankid-trust", CertificateFactory.getInstance("X.509").generateCertificate(this.trustedRoot.getInputStream()));
    }
}

