/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.bankid.rpapi.support;

import java.security.KeyStore;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class KeyStoreFactoryBean
extends AbstractFactoryBean<KeyStore> {
    private Resource keyStoreResource;
    private char[] keyStorePassword;
    private String keyStoreType;

    public KeyStoreFactoryBean(Resource keyStoreResource, char[] keyStorePassword) {
        this(keyStoreResource, keyStorePassword, KeyStore.getDefaultType());
    }

    public KeyStoreFactoryBean(Resource keyStoreResource, char[] keyStorePassword, String keyStoreType) {
        Assert.notNull((Object)keyStoreResource, (String)"'keyStoreResource' must not be null");
        Assert.hasText((String)keyStoreType, (String)"'keyStoreType' must not be null or empty");
        this.keyStoreResource = keyStoreResource;
        if (keyStorePassword != null) {
            this.keyStorePassword = new char[keyStorePassword.length];
            System.arraycopy(keyStorePassword, 0, this.keyStorePassword, 0, this.keyStorePassword.length);
        } else {
            this.keyStorePassword = new char[0];
        }
        this.keyStoreType = keyStoreType;
    }

    public Class<? extends KeyStore> getObjectType() {
        return KeyStore.class;
    }

    protected KeyStore createInstance() throws Exception {
        KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
        keyStore.load(this.keyStoreResource.getInputStream(), this.keyStorePassword);
        return keyStore;
    }
}

