/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.bankid.rpapi.support;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.time.Year;
import java.util.Calendar;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;
import se.litsec.bankid.rpapi.support.PersonalIdentityNumberException;

public class PersonalIdentityNumber
implements Serializable {
    private static final long serialVersionUID = 6546252010415273766L;
    private int century;
    private int year;
    private char delimiter;
    private int month;
    private int date;
    private int birthNumber;
    private int controlDigit;
    private static final Pattern pattern = Pattern.compile("^(\\d{2}){0,1}(\\d{2})(\\d{2})(\\d{2})([-|+]{0,1})?(\\d{3})(\\d{1})$");

    public PersonalIdentityNumber(String number) throws PersonalIdentityNumberException {
        Assert.notNull((Object)number, (String)"number must not be null");
        Matcher matcher = pattern.matcher(number.trim());
        if (!matcher.find()) {
            throw new PersonalIdentityNumberException("Invalid format of personal identity number");
        }
        try {
            this.processYear(matcher.group(1), matcher.group(2), matcher.group(5));
            this.month = Integer.parseInt(matcher.group(3));
            this.date = Integer.parseInt(matcher.group(4));
            if (this.date < 1 || this.date > 31 && this.date < 61 || this.date > 91) {
                throw new PersonalIdentityNumberException("Invalid date - " + matcher.group(4));
            }
            Calendar cal = Calendar.getInstance();
            cal.setLenient(false);
            cal.set(this.century * 100 + this.year, this.month - 1, this.date > 60 ? this.date - 60 : this.date);
            try {
                cal.getTime();
            }
            catch (Exception e) {
                String msg = this.date > 60 ? "Invalid samordningsnummer" : "Invalid birth date";
                throw new PersonalIdentityNumberException(String.format("%s - %02d%02d%02d%02d", msg, this.century, this.year, this.month, this.date));
            }
            this.birthNumber = Integer.parseInt(matcher.group(6));
            this.controlDigit = Integer.parseInt(matcher.group(7));
            int luhn = PersonalIdentityNumber.calculateLuhn(this.getNumber(Format.TEN_DIGITS_NO_DELIMITER).substring(0, 9));
            if (luhn != this.controlDigit) {
                throw new PersonalIdentityNumberException("Invalid personal identity number - control digit is incorrect");
            }
        }
        catch (NumberFormatException e) {
            throw new PersonalIdentityNumberException("Invalid personal number", e);
        }
    }

    @JsonCreator
    public static PersonalIdentityNumber parse(String number) throws PersonalIdentityNumberException {
        return new PersonalIdentityNumber(number);
    }

    @JsonValue
    public String getNumber() {
        return this.getNumber(Format.TWELVE_DIGITS_NO_DELIMITER);
    }

    public String getNumber(Format format) {
        if (format == Format.TWELVE_DIGITS_NO_DELIMITER) {
            return String.format("%02d%02d%02d%02d%03d%d", this.century, this.year, this.month, this.date, this.birthNumber, this.controlDigit);
        }
        if (format == Format.TWELVE_DIGITS_DELIMITER) {
            return String.format("%02d%02d%02d%02d%c%03d%d", this.century, this.year, this.month, this.date, Character.valueOf(this.delimiter), this.birthNumber, this.controlDigit);
        }
        if (format == Format.TEN_DIGITS_NO_DELIMITER) {
            return String.format("%02d%02d%02d%03d%d", this.year, this.month, this.date, this.birthNumber, this.controlDigit);
        }
        return String.format("%02d%02d%02d%c%03d%d", this.year, this.month, this.date, Character.valueOf(this.delimiter), this.birthNumber, this.controlDigit);
    }

    public boolean isSamordningsnummer() {
        return this.date > 60;
    }

    private void processYear(String centuryDigits, String yearDigits, String delimeter) throws NumberFormatException {
        this.year = Integer.parseInt(yearDigits);
        if (centuryDigits == null) {
            if ("-".equals(delimeter) || delimeter.isEmpty()) {
                this.century = Year.now().minusYears(this.year).getValue() / 100;
                this.delimiter = (char)45;
            } else {
                this.century = Year.now().minusYears(100 + this.year).getValue() / 100;
                this.delimiter = (char)43;
            }
        } else {
            this.century = Integer.parseInt(centuryDigits);
            this.delimiter = (char)(Year.now().getValue() - (this.century * 100 + this.year) >= 100 ? 43 : 45);
        }
    }

    private static int calculateLuhn(String number) {
        int luhn = 0;
        for (int i = number.length() - 1; i >= 0; --i) {
            int c = number.charAt(i) - 48;
            luhn += i % 2 == 0 ? ((c *= 2) > 9 ? c - 9 : c) : c;
        }
        return luhn != 0 ? 10 - luhn % 10 : luhn;
    }

    public int hashCode() {
        return Objects.hash(this.birthNumber, this.century, this.controlDigit, this.date, Character.valueOf(this.delimiter), this.month, this.year);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PersonalIdentityNumber)) {
            return false;
        }
        PersonalIdentityNumber other = (PersonalIdentityNumber)obj;
        return this.birthNumber == other.birthNumber && this.century == other.century && this.controlDigit == other.controlDigit && this.date == other.date && this.delimiter == other.delimiter && this.month == other.month && this.year == other.year;
    }

    public String toString() {
        return this.getNumber(Format.TWELVE_DIGITS_DELIMITER);
    }

    public static enum Format {
        TWELVE_DIGITS_NO_DELIMITER,
        TWELVE_DIGITS_DELIMITER,
        TEN_DIGITS_NO_DELIMITER,
        TEN_DIGITS_DELIMITER;

    }
}

