/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.bankid.rpapi.support.useragent;

import javax.servlet.http.HttpServletRequest;
import org.springframework.mobile.device.Device;
import org.springframework.mobile.device.LiteDeviceResolver;
import org.springframework.util.Assert;
import se.litsec.bankid.rpapi.support.useragent.UserAgent;
import se.litsec.bankid.rpapi.support.useragent.UserDeviceType;

public class DefaultUserAgent
implements UserAgent {
    private static final LiteDeviceResolver deviceResolver = new LiteDeviceResolver();
    private final HttpServletRequest request;
    private String userAgentHeader;

    public DefaultUserAgent(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"request must not be null");
        this.request = request;
        String header = this.request.getHeader("User-Agent");
        this.userAgentHeader = header != null ? header : "";
    }

    @Override
    public UserDeviceType getUserDeviceType() {
        Device device = deviceResolver.resolveDevice(this.request);
        if (device.isMobile()) {
            return UserDeviceType.MOBILE;
        }
        if (device.isTablet()) {
            return UserDeviceType.TABLET;
        }
        return UserDeviceType.DESKTOP;
    }

    @Override
    public String getUserAgentHeader() {
        return this.userAgentHeader;
    }

    @Override
    public String getUserIpAddress() {
        return this.request.getRemoteAddr();
    }

    @Override
    public boolean is_iOS() {
        String userAgent = this.getUserAgentHeader();
        return userAgent.contains("iphone") || userAgent.contains("ipod") || userAgent.contains("ipad");
    }

    @Override
    public boolean isNonEmbeddedMobileSafari() {
        String header = this.getUserAgentHeader();
        if (header.contains("AppleWebKit") && !header.contains("CriOS") && !header.contains("Chrome") && !header.contains("FxiOS")) {
            return !this.isEmbeddedBrowser();
        }
        return false;
    }

    @Override
    public boolean isEmbeddedBrowser() {
        String header = this.getUserAgentHeader();
        if (header.contains("GSA")) {
            return true;
        }
        if (header.contains("FBAN")) {
            return true;
        }
        return header.contains("Twitter");
    }
}

