/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.bankid.rpapi.types;

import se.litsec.bankid.rpapi.types.ErrorCode;
import se.litsec.bankid.rpapi.types.ErrorResponse;

public class BankIDException
extends Exception {
    private static final long serialVersionUID = 713980887665580664L;
    private ErrorCode errorCode;
    private String details;

    public BankIDException(ErrorResponse errorResponse) {
        this.errorCode = errorResponse.getErrorCode();
        this.details = errorResponse.getDetails();
    }

    public BankIDException(ErrorResponse errorResponse, String message) {
        super(message);
        this.errorCode = errorResponse.getErrorCode();
        this.details = errorResponse.getDetails();
    }

    public BankIDException(ErrorResponse errorResponse, Throwable cause) {
        super(cause);
        this.errorCode = errorResponse.getErrorCode();
        this.details = errorResponse.getDetails();
    }

    public BankIDException(ErrorResponse errorResponse, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorResponse.getErrorCode();
        this.details = errorResponse.getDetails();
    }

    public BankIDException(ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public BankIDException(ErrorCode errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
    }

    public BankIDException(ErrorCode errorCode, Throwable cause) {
        super(cause);
        this.errorCode = errorCode;
    }

    public BankIDException(ErrorCode errorCode, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    @Override
    public String toString() {
        return String.format("error-code='%s', details=%s", this.errorCode != null ? this.errorCode.getValue() : "unknown", this.details != null ? this.details : "<not-set>");
    }
}

