/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.bankid.rpapi.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import se.litsec.bankid.rpapi.types.CollectResponse;
import se.litsec.bankid.rpapi.types.CompletionData;
import se.litsec.bankid.rpapi.types.ErrorCode;
import se.litsec.bankid.rpapi.types.ProgressStatus;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CollectResponseJson
implements CollectResponse {
    @JsonProperty(value="orderRef", required=true)
    private String orderReference;
    @JsonProperty(value="status", required=true)
    private Status status;
    @JsonProperty(value="hintCode", required=false)
    private String hintCode;
    @JsonProperty(value="completionData", required=false)
    private CompletionData completionData;

    @Override
    public String getOrderReference() {
        return this.orderReference;
    }

    public void setOrderReference(String orderReference) {
        this.orderReference = orderReference;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Override
    public ProgressStatus getProgressStatus() {
        if (Status.COMPLETE.equals((Object)this.status)) {
            return ProgressStatus.COMPLETE;
        }
        if (Status.PENDING.equals((Object)this.status)) {
            return ProgressStatus.forValue(this.hintCode);
        }
        return null;
    }

    public ErrorCode getErrorCode() {
        if (Status.FAILED.equals((Object)this.status)) {
            return ErrorCode.forValue(this.hintCode);
        }
        return null;
    }

    @Override
    public CompletionData getCompletionData() {
        return this.completionData;
    }

    public void setCompletionData(CompletionData completionData) {
        this.completionData = completionData;
    }

    public void setHintCode(String hintCode) {
        this.hintCode = hintCode;
    }

    public static enum Status {
        PENDING("pending"),
        FAILED("failed"),
        COMPLETE("complete");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            for (Status s : Status.values()) {
                if (!s.getValue().equalsIgnoreCase(value)) continue;
                return s;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

