/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.bankid.rpapi.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Requirement {
    public static final String CP_BANKID_ON_FILE = "1.2.752.78.1.1";
    public static final String CP_BANKID_ON_SMARTCARD = "1.2.752.78.1.2";
    public static final String CP_MOBILE_BANKID = "1.2.752.78.1.5";
    public static final String CP_NORDEA_EID = "1.2.752.71.1.3";
    public static final String CP_BANKID_ON_FILE_TEST = "1.2.3.4.5";
    public static final String CP_BANKID_ON_SMARTCARD_TEST = "1.2.3.4.10";
    public static final String CP_MOBILE_BANKID_TEST = "1.2.3.4.25";
    public static final String CP_NORDEA_EID_TEST = "1.2.752.71.1.3";
    public static final String CP_TEST_BANKID = "1.2.752.60.1.6";
    public static final String NORDEA_CA_SMARTCARD = "Nordea CA for Smartcard users 12";
    public static final String NORDEA_CA_SMARTCARD_TEST = "Nordea Test CA for Smartcard users 12";
    public static final String NORDEA_CA_FILE = "Nordea CA for Softcert users 13";
    public static final String NORDEA_CA_FILE_TEST = "Nordea Test CA for Softcert users 13";
    private CardReaderRequirement cardReader;
    private List<String> certificatePolicies;
    private List<String> issuerCn;
    private Boolean autoStartTokenRequired;
    private Boolean allowFingerprint;
    private Boolean tokenStartRequired;

    public static RequirementBuilder builder() {
        return new RequirementBuilder();
    }

    public boolean isEmpty() {
        return this.cardReader == null && this.autoStartTokenRequired == null && this.tokenStartRequired == null && (this.certificatePolicies == null || this.certificatePolicies.isEmpty()) && this.issuerCn == null && this.allowFingerprint == null;
    }

    public CardReaderRequirement getCardReader() {
        return this.cardReader;
    }

    public void setCardReader(CardReaderRequirement cardReader) {
        this.cardReader = cardReader;
    }

    public List<String> getCertificatePolicies() {
        return this.certificatePolicies;
    }

    public void setCertificatePolicies(List<String> certificatePolicies) {
        this.certificatePolicies = certificatePolicies;
    }

    public List<String> getIssuerCn() {
        return this.issuerCn;
    }

    public void setIssuerCn(List<String> issuerCn) {
        this.issuerCn = issuerCn;
    }

    @Deprecated
    public Boolean getAutoStartTokenRequired() {
        return this.autoStartTokenRequired;
    }

    @Deprecated
    public void setAutoStartTokenRequired(Boolean autoStartTokenRequired) {
        this.autoStartTokenRequired = autoStartTokenRequired != null && autoStartTokenRequired == false ? null : autoStartTokenRequired;
    }

    public Boolean getAllowFingerprint() {
        return this.allowFingerprint;
    }

    public void setAllowFingerprint(Boolean allowFingerprint) {
        this.allowFingerprint = allowFingerprint;
    }

    public Boolean getTokenStartRequired() {
        return this.tokenStartRequired;
    }

    public void setTokenStartRequired(Boolean tokenStartRequired) {
        this.tokenStartRequired = tokenStartRequired;
    }

    public String toString() {
        return String.format("cardReader=%s, certificatePolicies=%s, issuerCn=%s, autoStartTokenRequired=%s, allowFingerprint=%s, tokenStartRequired=%s", this.cardReader != null ? this.cardReader : "<not set>", this.certificatePolicies != null ? this.certificatePolicies : "<not set - defaults apply>", this.issuerCn != null ? this.issuerCn : "<not set - defaults apply>", this.autoStartTokenRequired != null ? this.autoStartTokenRequired : "<not set>", this.allowFingerprint != null ? this.allowFingerprint : "<not set>", this.tokenStartRequired != null ? this.tokenStartRequired : "<not set>");
    }

    public static enum CardReaderRequirement {
        CLASS1("class1"),
        CLASS2("class2");

        private String value;

        private CardReaderRequirement(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CardReaderRequirement forValue(String value) {
            for (CardReaderRequirement cr : CardReaderRequirement.values()) {
                if (!cr.getValue().equals(value)) continue;
                return cr;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }

    public static class RequirementBuilder {
        private Requirement requirement = new Requirement();
        private boolean productionSetup = true;
        private boolean enableMobile = true;
        private boolean enableOnFile = true;
        private boolean enableOnSmartCard = true;
        private boolean enableNordea = true;

        public RequirementBuilder() {
        }

        public RequirementBuilder(Requirement requirement) {
            this();
            if (requirement == null) {
                return;
            }
            if (requirement.getCertificatePolicies() != null && !requirement.getCertificatePolicies().isEmpty()) {
                this.enableMobile = requirement.getCertificatePolicies().contains(Requirement.CP_MOBILE_BANKID) || requirement.getCertificatePolicies().contains(Requirement.CP_MOBILE_BANKID_TEST);
                this.enableOnFile = requirement.getCertificatePolicies().contains(Requirement.CP_BANKID_ON_FILE) || requirement.getCertificatePolicies().contains(Requirement.CP_BANKID_ON_FILE_TEST);
                this.enableOnSmartCard = requirement.getCertificatePolicies().contains(Requirement.CP_BANKID_ON_SMARTCARD) || requirement.getCertificatePolicies().contains(Requirement.CP_BANKID_ON_SMARTCARD_TEST);
                this.enableNordea = requirement.getCertificatePolicies().contains("1.2.752.71.1.3") || requirement.getCertificatePolicies().contains("1.2.752.71.1.3");
            }
            this.requirement.setCardReader(requirement.getCardReader());
            this.requirement.setAllowFingerprint(requirement.getAllowFingerprint());
            this.requirement.setAutoStartTokenRequired(requirement.getAutoStartTokenRequired());
            this.requirement.setTokenStartRequired(requirement.getTokenStartRequired());
            this.requirement.setIssuerCn(requirement.getIssuerCn());
        }

        public Requirement build() {
            if (this.enableMobile && this.enableOnFile && this.enableOnSmartCard && this.enableNordea) {
                return this.requirement;
            }
            List<String> oids = Arrays.asList(RequirementBuilder.BANKID_ON_FILE(this.productionSetup), RequirementBuilder.BANKID_ON_SMARTCARD(this.productionSetup), RequirementBuilder.MOBILE_BANKID(this.productionSetup), RequirementBuilder.NORDEA_EID(this.productionSetup));
            List<String> issuerCns = Arrays.asList(RequirementBuilder.NORDEA_CA_FILE(this.productionSetup), RequirementBuilder.NORDEA_CA_SMARTCARD(this.productionSetup));
            if (!this.enableMobile) {
                oids.removeIf(item -> item.equals(RequirementBuilder.MOBILE_BANKID(this.productionSetup)));
            }
            if (!this.enableOnFile) {
                oids.removeIf(item -> item.equals(RequirementBuilder.BANKID_ON_FILE(this.productionSetup)));
                issuerCns.removeIf(item -> item.equals(RequirementBuilder.NORDEA_CA_FILE(this.productionSetup)));
            }
            if (!this.enableOnSmartCard) {
                oids.removeIf(item -> item.equals(RequirementBuilder.BANKID_ON_SMARTCARD(this.productionSetup)));
                issuerCns.removeIf(item -> item.equals(RequirementBuilder.NORDEA_CA_SMARTCARD(this.productionSetup)));
                this.requirement.setCardReader(null);
                if (!this.enableOnFile) {
                    oids.removeIf(item -> item.equals(RequirementBuilder.NORDEA_EID(this.productionSetup)));
                    this.requirement.setIssuerCn(null);
                }
            }
            if (!this.enableNordea) {
                oids.removeIf(item -> item.equals(RequirementBuilder.NORDEA_EID(this.productionSetup)));
                this.requirement.setIssuerCn(null);
            }
            this.requirement.setCertificatePolicies(oids);
            if (issuerCns.size() != 2) {
                this.requirement.setIssuerCn(issuerCns);
            }
            return this.requirement;
        }

        public RequirementBuilder productionSetup(boolean production) {
            this.productionSetup = production;
            return this;
        }

        public RequirementBuilder cardReader(CardReaderRequirement cardReaderRequirement) {
            this.requirement.setCardReader(cardReaderRequirement);
            return this;
        }

        @Deprecated
        public RequirementBuilder autoStartTokenRequired() {
            this.requirement.setAutoStartTokenRequired(Boolean.TRUE);
            return this;
        }

        public RequirementBuilder allowFingerprint(boolean allowFingerprint) {
            this.requirement.setAllowFingerprint(allowFingerprint);
            return this;
        }

        public RequirementBuilder tokenStartRequired() {
            this.requirement.setTokenStartRequired(Boolean.TRUE);
            return this;
        }

        public RequirementBuilder mobile(boolean enable) {
            this.enableMobile = enable;
            return this;
        }

        public RequirementBuilder onFile(boolean enable) {
            this.enableOnFile = enable;
            return this;
        }

        public RequirementBuilder onSmartCard(boolean enable) {
            this.enableOnSmartCard = enable;
            return this;
        }

        public RequirementBuilder nordea(boolean enable) {
            this.enableNordea = enable;
            return this;
        }

        public static String BANKID_ON_FILE(boolean production) {
            return production ? Requirement.CP_BANKID_ON_FILE : Requirement.CP_BANKID_ON_FILE_TEST;
        }

        public static String BANKID_ON_SMARTCARD(boolean production) {
            return production ? Requirement.CP_BANKID_ON_SMARTCARD : Requirement.CP_BANKID_ON_SMARTCARD_TEST;
        }

        public static String MOBILE_BANKID(boolean production) {
            return production ? Requirement.CP_MOBILE_BANKID : Requirement.CP_MOBILE_BANKID_TEST;
        }

        public static String NORDEA_EID(boolean production) {
            return production ? "1.2.752.71.1.3" : "1.2.752.71.1.3";
        }

        public static String NORDEA_CA_SMARTCARD(boolean production) {
            return production ? Requirement.NORDEA_CA_SMARTCARD : Requirement.NORDEA_CA_SMARTCARD_TEST;
        }

        public static String NORDEA_CA_FILE(boolean production) {
            return production ? Requirement.NORDEA_CA_FILE : Requirement.NORDEA_CA_FILE_TEST;
        }
    }
}

